/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class Marker {
    private final int id;
    private final ResourceLocation type;
    private final Component label;
    private final ResourceKey<Level> world;
    private final int x;
    private final int z;
    private final boolean visibleAhead;
    private boolean isGlobal;

    public Marker(int id, ResourceLocation type, Component label, ResourceKey<Level> world, int x, int z, boolean visibleAhead) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.world = world;
        this.x = x;
        this.z = z;
        this.visibleAhead = visibleAhead;
    }

    public Marker(ResourceLocation type, ResourceKey<Level> world, Precursor precursor) {
        this(precursor.id, type, precursor.label, world, precursor.x, precursor.z, precursor.visibleAhead);
    }

    public int getId() {
        return this.id;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public Component getLabel() {
        return this.label;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public boolean isVisibleAhead() {
        return this.visibleAhead;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    Marker setGlobal(boolean value) {
        this.isGlobal = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)obj;
        return this.id == marker.id;
    }

    public ChunkPos getChunkCoords() {
        return new ChunkPos(new BlockPos(this.x, 0, this.z));
    }

    public String toString() {
        return "#" + this.id + "\"" + this.label.getString() + "\"@(" + this.x + ", " + this.z + ")";
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
        buf.m_130083_(this.label);
        buf.m_130130_(this.x);
        buf.m_130130_(this.z);
        buf.writeBoolean(this.visibleAhead);
    }

    public static class Precursor {
        private final int id;
        private final Component label;
        private final int x;
        private final int z;
        private final boolean visibleAhead;

        public Precursor(FriendlyByteBuf buf) {
            this.id = buf.m_130242_();
            this.label = buf.m_130238_();
            this.x = buf.m_130242_();
            this.z = buf.m_130242_();
            this.visibleAhead = buf.readBoolean();
        }
    }
}

